package ru.yandex.chemodan.app.dataapi.core.dao.data;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.ShardPartitionLocator;
import ru.yandex.misc.db.q.SqlLimits;

/**
 * @author tolmalev
 */
public interface DeletedDatabasesJdbcDao {
    void saveAsDeleted(Database database, Instant deleteTime);

    void saveAsDeletedBatch(DataApiUserId uid, ListF<Database> databases);

    void removeFromDeleted(Database database);

    void removeFromDeleted(DataApiUserId uid, DatabaseHandle dbHandle);

    int findDatabasesCount(DataApiUserId uid);

    int findDatabasesCount(DataApiUserId uid, ListF<Database> databases);

    ListF<Database> find(DataApiUserId uid, boolean locakForUpdate);

    Option<Database> find(DataApiUserId uid, DatabaseHandle dbHandle);

    ListF<Database> findDeletedBefore(ShardPartitionLocator shardPartition, Instant before, SqlLimits limits);

    ListF<ShardPartitionLocator> getShardPartitions();
}
