package ru.yandex.chemodan.app.dataapi.core.dao.support;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.spring.jdbc.rewriteQuery.QueryRewriter;

/**
 * @author tolmalev
 */
public class AddCommentQueryRewriter implements QueryRewriter {
    private final Option<QueryRewriter> prevRewriter;

    private final Option<String> sql;
    private final Option<String> uid;

    public AddCommentQueryRewriter(Option<QueryRewriter> prevRewriter, Option<String> sql, Option<String> uid) {
        this.prevRewriter = prevRewriter;
        this.sql = sql;
        this.uid = uid;
    }

    @Override
    public String rewriteQuery(String q) {
        String prevQ = prevRewriter.map(rw -> rw.rewriteQuery(q)).getOrElse(q);

        String comment = getComment(sql, uid);

        return comment + " " + prevQ;
    }

    static String getComment(Option<String> sql, Option<String> uid) {
        return sql.map(sq -> "sql: " + sq)
                .plus(uid.map(u -> "uid: " + u))
                .mkString("/* ", ", ", " */");
    }
}
