package ru.yandex.chemodan.app.dataapi.core.dao.support;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class AddCommentQueryRewriterTest {
    @Test
    public void rewriteQuery() throws Exception {
        assertRewrite("/*  */ Select 1", Option.empty(), Option.empty());
        assertRewrite("/* sql: GetFreshCounter, uid: 5362990 */ Select 1",
                Option.of("GetFreshCounter"), Option.of("5362990"));
        assertRewrite("/* sql: GetFreshCounter */ Select 1",
                Option.of("GetFreshCounter"), Option.empty());
        assertRewrite("/* uid: 5362990 */ Select 1",
                Option.empty(), Option.of("5362990"));
    }

    private void assertRewrite(String result, Option<String> sql, Option<String> uid) {
        Assert.equals(result,
                new AddCommentQueryRewriter(Option.empty(), sql, uid).rewriteQuery("Select 1"));
    }

    @Test
    public void getComment() throws Exception {
        Assert.equals("/*  */", AddCommentQueryRewriter.getComment(Option.empty(), Option.empty()));

        Assert.equals("/* sql: GetFreshCounter, uid: 5362990 */",
                AddCommentQueryRewriter.getComment(Option.of("GetFreshCounter"), Option.of("5362990")));

        Assert.equals("/* uid: 5362990 */",
                AddCommentQueryRewriter.getComment(Option.empty(), Option.of("5362990")));

        Assert.equals("/* sql: GetFreshCounter */",
                AddCommentQueryRewriter.getComment(Option.of("GetFreshCounter"), Option.empty()));
    }
}
