package ru.yandex.chemodan.app.dataapi.core.dao.support;

import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.spring.jdbc.intercept.QueryInfo;
import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptor;
import ru.yandex.misc.spring.jdbc.intercept.QueryResultInfo;

/**
 * @author tolmalev
 */
public class DataApiMasterSlavePolicyQueryInterceptor implements QueryInterceptor {
    @Override
    public Object queryStarted(QueryInfo q) {
        MasterSlavePolicy policy = MasterSlaveContextHolder.policy();

        if (!q.isSelect() && policy != MasterSlavePolicy.RW_M) {
            return MasterSlaveContextHolder.push(MasterSlavePolicy.RW_M);
        }

        return null;
    }

    @Override
    public void queryCompleted(Object tag, QueryResultInfo result) {
        if (tag != null) {
            ((MasterSlaveContextHolder.PolicyHandle) tag).popSafely();
        }
    }
}
