package ru.yandex.chemodan.app.dataapi.core.dao.support;

import java.lang.reflect.Type;

import com.google.gson.reflect.TypeToken;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.CollectionIdCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DataColumn;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DataCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordIdCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByDataRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByIdRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.RecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeType;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserType;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiYaTeamUserId;
import ru.yandex.commune.random.RandomValueGenerator;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author tolmalev
 */
public class DataApiRandomValueGenerator extends RandomValueGenerator {
    private static final long FIRST_YANDEX_TEAM = 1120000000000000L;

    public DataApiRandomValueGenerator() {
        super(true);
    }

    private static final Type orderComponentListType = new TypeToken<ListF<ByDataRecordOrder.Component>>() {}.getType();

    public Object randomValueImpl(TypeX type) {
        if (type.erasure().is(DataRecordId.class)) {
            return createRecordId();
        } else if (type.erasure().is(DatabaseHandle.class)) {
                return createDatabaseHandle();
        } else if (type.erasure().is(DataField.class)) {
            return createDataField();
        } else if (type.erasure().is(Database.class)) {
            return createDatabase();
        } else if (type.erasure().is(RecordChange.class)) {
            return createRecordChange();
        } else if (type.erasure().is(FieldChange.class)) {
            return createFieldChange();
        } else if (type.erasure().is(Delta.class)) {
            return createDelta();
        } else if (type.erasure().is(DataApiUserId.class)) {
            return createDataApiUserId();
        } else if (type.erasure().is(DatabaseRef.class)) {
            return createDatabaseRef();
        } else if (type.erasure().is(DatabaseContext.class)) {
            return createDatabaseContext();
        } else if (type.erasure().is(CollectionIdCondition.class)) {
            return CollectionIdCondition.all();
        } else if (type.erasure().is(RecordIdCondition.class)) {
            return RecordIdCondition.all();
        } else if (type.erasure().is(DataCondition.class)) {
            return DataCondition.all();
        } else if (type.erasure().is(RecordCondition.class)) {
            return RecordCondition.all();
        } else if (type.erasure().is(DataColumn.class)) {
            switch (Random2.R.nextInt(5)) {
                case 0:
                    return DataColumn.string(Random2.R.nextAlnum(10));
                case 1:
                    return DataColumn.bool(Random2.R.nextAlnum(10));
                case 2:
                    return DataColumn.timestamp(Random2.R.nextAlnum(10));
                case 3:
                    return DataColumn.decimal(Random2.R.nextAlnum(10));
                default:
                    return DataColumn.integer(Random2.R.nextAlnum(10));
            }
        } else if (type.erasure().is(ByDataRecordOrder.Component.class)) {
            return Random2.R.nextBoolean()
                    ? ByDataRecordOrder.orderBy(randomValue(DataColumn.class))
                    : ByDataRecordOrder.orderByDesc(randomValue(DataColumn.class));

        } else if (type.erasure().is(RecordOrder.class)) {
            return Random2.R.nextBoolean()
                    ? Random2.R.randomElement(ByIdRecordOrder.values())
                    : new ByDataRecordOrder(randomValue(TypeX.wrap(orderComponentListType)));
        } else {
            return super.randomValueImpl(type);
        }
    }

    private Delta createDelta() {
        Option<Long> rev = Option.of(Random2.R.nextLong());
        return new Delta(Cf.list(randomValue(RecordChange[].class)),
                Option.of(Random2.R.nextAlnum(10)), rev, Option.of(rev.get() + 1));
    }

    public DataApiUserId createDataApiUserId() {
        return createDataApiUserId(Option.empty());
    }

    public DataApiUserId createDataApiUserId(Option<DataApiUserType> userTypeO) {
        DataApiUserType userType = userTypeO.getOrElse(randomValue(DataApiUserType.class));

        if (userType == DataApiUserType.PASSPORT || userType == DataApiUserType.PUBLIC) {
            return new DataApiPassportUserId(PassportUid.cons(randomLong() + 1));
        } else if (userType == DataApiUserType.YT) {
            return new DataApiYaTeamUserId(FIRST_YANDEX_TEAM + randomLong());
        } else {
            return userType.parse(Random2.R.nextAlnum(15));
        }
    }

    public RecordChange createRecordChange() {
        RecordChangeType type = randomValue(RecordChangeType.class);
        SimpleRecordId recId = new SimpleRecordId(
                Random2.R.nextString(10),
                Random2.R.nextString(10)
        );
        if (type == RecordChangeType.DELETE) {
            return RecordChange.delete(recId);
        } else if (type == RecordChangeType.INSERT || type == RecordChangeType.SET) {
            int c = Random2.R.nextInt(10);

            MapF<String, DataField> data = Cf.hashMap();
            for (int i = 0; i < c; i++) {
                data.put(Random2.R.nextString(5), createDataField());
            }

            if (type == RecordChangeType.INSERT) {
                return RecordChange.insert(recId, data);
            } else {
                return RecordChange.set(recId, data);
            }
        } else if (type == RecordChangeType.UPDATE) {
            int c = Random2.R.nextInt(10);
            ListF<FieldChange> changes = Cf.range(0, c).map(integer -> createFieldChange());
            return RecordChange.update(recId, changes);
        } else {
            throw new RuntimeException("Unknown type " + type);
        }
    }

    public FieldChange createFieldChange() {
        FieldChange.FieldChangeType type = Random2.R.nextEnum(FieldChange.FieldChangeType.class);
        switch (type) {
            case DELETE: return FieldChange.delete(Random2.R.nextString(5));
            case PUT: return FieldChange.put(Random2.R.nextString(5), createDataField());
            case DELETE_LIST_ITEM:
                return FieldChange.deleteListItem(Random2.R.nextString(5), Random2.R.nextInt(10));
            case PUT_LIST_ITEM:
                return FieldChange.putListItem(Random2.R.nextString(5), Random2.R.nextInt(10),
                        createDataField());
            case INSERT_LIST_ITEM:
                return FieldChange.insertListItem(Random2.R.nextString(5), Random2.R.nextInt(10),
                        createDataField());
            case MOVE_LIST_ITEM:
                return FieldChange.moveListItem(Random2.R.nextString(5), Random2.R.nextInt(10),
                        Random2.R.nextInt(10));
            default:
                throw new IllegalStateException("Unknown type " + type);
        }
    }

    public Database createDatabase() {
        return createDatabase(Option.empty(), Option.empty());
    }

    public Database createDatabase(DatabaseRef dbRef) {
        return createDatabase(Option.of(dbRef.databaseId()), dbRef.appNameO());
    }

    public Database createDatabaseByApp(String appName) {
        return createDatabase(Option.empty(), Option.of(appName));
    }

    private Database createDatabase(Option<String> databaseId, Option<String> app) {
        DatabaseHandle dbHandle = new DatabaseHandle(
                app.getOrElse(r.nextString(10)), databaseId.getOrElse(r.nextString(10)), r.nextString(20));
        return new Database(
                randomUser(),
                dbHandle,
                r.nextNonNegativeLong(),
                new DatabaseMeta(
                        r.nextInstant(new Instant(100), Instant.now()),
                        r.nextInstant(new Instant(100), Instant.now()),
                        DataSize.fromBytes(r.nextNonNegativeInt()),
                        r.nextInt(100)
                )
        );
    }

    public DataField createDataField() {
        return createDataField(r.nextEnum(DataFieldType.class));
    }

    public DataField createDataField(DataFieldType type) {
        return new DataField(type, createValueForType(type));
    }

    public Object createValueForType(DataFieldType type) {
        switch (type) {
            case NAN: return Double.NaN;
            case INFINITY: return Double.POSITIVE_INFINITY;
            case NEGATIVE_INFINITY: return Double.NEGATIVE_INFINITY;
            case NULL: return null;
            case LIST: {
                return Cf.range(0, Random2.R.nextInt(10)).map(integer -> createDataField());
            }
            case MAP: {
                MapF<String, DataField> map = Cf.hashMap();
                Cf.range(0, Random2.R.nextInt(10)).forEach(value -> map.put(value.toString(), createDataField()));
                return map;
            }
            case DATETIME: {
                return DateTime.now(
                        DateTimeZone.forOffsetHours(Random2.R.nextInt(10))).plusMinutes(Random2.R.nextInt(10));
            }

            default: return randomValue(type.valueClass);
        }
    }

    public DataRecordId createRecordId() {
        return new DataRecordId(createDatabaseHandle(), r.nextString(10), r.nextString(10));
    }

    public DatabaseHandle createDatabaseHandle() {
        return createDatabaseRef()
                .consHandle(r.nextString(10));
    }

    public DataApiUserId randomUser() {
        return new DataApiPassportUserId(PassportUid.cons(randomLong() + 1));
    }

    public DatabaseAppContext createDatabaseContext() {
        return new DatabaseAppContext(r.nextString(10));
    }

    public DatabaseRef createDatabaseRef() {
        return new AppDatabaseRef(r.nextString(10), r.nextString(20));
    }
}
