package ru.yandex.chemodan.app.dataapi.core.dao.support;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.VisibleBufferedInputStream;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.jdbc.PgConnection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.chemodan.app.dataapi.core.dao.test.DataApiShardDaoTestContextLoader;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.db.WrappingConnection;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(
        loader = DataApiShardDaoTestContextLoader.class,
        initializers = DataApiShardDaoTestContextLoader.class
)
public class PgConnectionHackTest {

    @Autowired
    private ShardManager2 shardManager2;
    @Value("${dataapi.shard.default-number}")
    private int defaultShardNumber;

    // CHEMODAN-28677
    @Test
    public void ignoreUnexpectedZCommand() throws SQLException {
        DataSource datasource = shardManager2.getShard(defaultShardNumber).getDataSource();
        Connection connection = DataSourceUtils.getConnection(datasource);

        DataSource dsMock = Mockito.mock(DataSource.class);
        Mockito.when(dsMock.getConnection()).thenReturn(new WrappingConnection(connection) {
            public void close() throws SQLException {}
        });
        JdbcTemplate3 template = new JdbcTemplate3(dsMock);

        try {
            QueryExecutor executor = connection.unwrap(PgConnection.class).getQueryExecutor();
            Assert.equals(1, template.queryForInt("SELECT 1"));

            injectZCommand(executor);
            Assert.equals(2, template.queryForInt("SELECT 2"));

            injectZCommand(executor);
            Assert.isTrue(connection.isValid(1));
            Assert.equals(3, template.queryForInt("SELECT 3"));

        } finally {
            DataSourceUtils.releaseConnection(connection, datasource);
        }

    }

    private static void injectZCommand(QueryExecutor executor) {
        FieldX pgStreamF = field(QueryExecutorImpl.class, "pgStream");
        FieldX pgInputF = field(PGStream.class, "pg_input");
        FieldX endIndexF = field(VisibleBufferedInputStream.class, "endIndex");

        PGStream stream = (PGStream) pgStreamF.get(executor);
        VisibleBufferedInputStream input = (VisibleBufferedInputStream) pgInputF.get(stream);

        byte[] buffer = input.getBuffer();
        int index = input.getIndex();

        buffer[index] = 90;
        buffer[++index] = 0;
        buffer[++index] = 0;
        buffer[++index] = 0;
        buffer[++index] = 5;
        buffer[++index] = 73;

        endIndexF.set(input, ((int) endIndexF.get(input)) + 6);
    }

    private static FieldX field(Class<?> clazz, String name) {
        return ClassX.wrap(clazz).getDeclaredField(name).setAccessibleTrueReturnThis();
    }
}
