package ru.yandex.chemodan.app.dataapi.core.dao.support;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.UserShardId;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.lang.Check;

/**
 * @author dbrylev
 */
public class TransactionUserShardIdHolder {
    private static final ThreadLocalX<UserShardId> userShardId = new ThreadLocalX<>();

    public static void checkUserShardNotChanged(UserShardId shard) {
        checkHoldsUser(shard.userId);

        int shardId = userShardId.get().shardId;
        if (shardId != shard.shardId) {
            throw new UserShardChangedDuringTransactionException(shard.userId, shardId, shard.shardId);
        }
    }

    public static boolean holdsUser(DataApiUserId uid) {
        return userShardId.getO().isPresent() && userShardId.get().userId.equals(uid);
    }

    public static void checkHoldsUser(DataApiUserId uid) {
        Check.isTrue(holdsUser(uid));
    }

    public static Option<UserShardId> getO() {
        return userShardId.getO();
    }

    public static int getHoldingShardId() {
        return userShardId.getO().get().shardId;
    }

    public static void set(UserShardId shard) {
        userShardId.set(shard);
    }

    public static void remove() {
        userShardId.remove();
    }
}
