package ru.yandex.chemodan.app.dataapi.core.dao.usermeta;

import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.util.sharpei.ShardUserInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 */
@Bendable
@Data
@EqualsAndHashCode(of = "userId")
public class MetaUser extends ShardUserInfo {

    @BenderPart
    private final DataApiUserId userId;

    public MetaUser(DataApiUserId userId, int shardId, boolean ro, SetF<String> migrated) {
        super(shardId, ro, migrated.unmodifiable());
        this.userId = userId;
    }

    public static MetaUser from(DataApiUserId userId, ShardUserInfo info) {
        return new MetaUser(userId, info.getShardId(), info.isRo(), info.getMigrated());
    }

    public boolean isMigrated(DatabaseRef ref) {
        return getMigrated().containsTs(ref.toString());
    }

    public MetaUser withMigrated(DatabaseRef databaseRef) {
        return new MetaUser(
                userId,
                getShardId(),
                isRo(),
                getMigrated().plus1(databaseRef.toString())
        );
    }

    public MetaUser withoutMigrated(DatabaseRef databaseRef) {
        return new MetaUser(
                userId,
                getShardId(),
                isRo(),
                getMigrated().minus1(databaseRef.toString())
        );
    }

}
