package ru.yandex.chemodan.app.dataapi.core.dao.usermeta;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author tolmalev
 */
public interface UserMetaManager {

    Option<MetaUser> findMetaUser(DataApiUserId user);

    default Option<MetaUser> findMetaUser(DataApiUserId user, boolean forRead) {
        return findMetaUser(user);
    }

    ListF<MetaUser> findMetaUsers(ListF<DataApiUserId> userIds);

    MetaUser registerIfNotExists(DataApiUserId user);

    void registerBatch(ListF<DataApiUserId> usersIds);

    void updateReadOnly(DataApiUserId user, boolean readOnly);

    void updateMigrated(DataApiUserId user, DatabaseRef ref, boolean migrated);

    void updateShardIdAndReadOnly(DataApiUserId user, int toShardId, boolean readOnly);
}
