package ru.yandex.chemodan.app.dataapi.core.dao.usermeta;

import java.util.concurrent.Semaphore;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.concurrent.ConcurrentUtils;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class UserMetaManagerWithSemaphore {
    private final UserMetaManager userMetaManager;

    private <T> T executeWithSemaphore(Function0<T> action, Semaphore semaphore) {
        T result;
        try {
            ConcurrentUtils.acquire(semaphore);
            result = action.apply();
        } finally {
            semaphore.release();
        }
        return result;
    }

    private void executeWithSemaphoreV(Function0V action, Semaphore semaphore) {
        executeWithSemaphore(action.asFunction0ReturnNull(), semaphore);
    }

    public Option<MetaUser> findMetaUser(DataApiUserId user, Semaphore semaphore) {
        return executeWithSemaphore(() -> userMetaManager.findMetaUser(user, true), semaphore);
    }

    public ListF<MetaUser> findMetaUsers(ListF<DataApiUserId> userIds, Semaphore semaphore) {
        return executeWithSemaphore(() -> userMetaManager.findMetaUsers(userIds), semaphore);
    }

    public MetaUser registerIfNotExists(DataApiUserId user, Semaphore semaphore) {
        return executeWithSemaphore(() -> userMetaManager.registerIfNotExists(user), semaphore);
    }

    public void registerBatch(ListF<DataApiUserId> usersIds, Semaphore semaphore) {
        executeWithSemaphoreV(() -> userMetaManager.registerBatch(usersIds), semaphore);
    }

    public void updateReadOnly(DataApiUserId user, boolean readOnly, Semaphore semaphore) {
        executeWithSemaphoreV(() -> userMetaManager.updateReadOnly(user, readOnly), semaphore);
    }

    public void updateShardIdAndReadOnly(DataApiUserId user, int toShardId, boolean readOnly, Semaphore semaphore) {
        executeWithSemaphoreV(() -> userMetaManager.updateShardIdAndReadOnly(user, toShardId, readOnly), semaphore);
    }
}
