package ru.yandex.chemodan.app.dataapi.core.dao.usermeta.migration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class DataSourceMigrationInfo extends DefaultObject {
    private final MapF<DatabaseRef, DataSourceType> refToType;

    public DataSourceMigrationInfo() {
        this(Cf.map());
    }

    public DataSourceMigrationInfo(MapF<DatabaseRef, DataSourceType> refToType) {
        this.refToType = refToType;
    }

    public Option<DataSourceType> getTypeO(DatabaseRef databaseRef) {
        return refToType.getO(databaseRef);
    }

    public DataSourceMigrationInfo withRefType(DatabaseRef ref, DataSourceType type) {
        return new DataSourceMigrationInfo(refToType.plus1(ref, type));
    }

    public boolean isNotEmpty() {
        return refToType.isNotEmpty();
    }
}
