package ru.yandex.chemodan.app.dataapi.core.dao.usermeta.migration;

import java.util.concurrent.Semaphore;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author yashunsky
 */

public interface MigrationControl {
    ChunkRateLimiter getSelectLimiter();
    ChunkRateLimiter getInsertLimiter();
    ChunkRateLimiter getDeleteLimiter();
    Semaphore getSharpeiSemaphore();

    Duration getRoPause();
    Duration getLockDelay();
    Duration getReplicationPause();
    boolean isLogsCheckEnabled();
    Duration getLogsCheckDelay();
    Duration getCleaningDelay();
    boolean isAllowedToCleanDestinationShard();

    default boolean isMigrationPossible(ListF<Integer> shardIds) {
        return true;
    }

    default RateLimiters getLimiters() {
        return new RateLimiters(getSelectLimiter(), getInsertLimiter(), getDeleteLimiter(), getSharpeiSemaphore());
    }
}
