package ru.yandex.chemodan.app.dataapi.core.dao.usermeta.migration;

import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class MigrationInfo extends DefaultObject {
    @BenderFlatten
    public final DataSourceMigrationInfo dsMigration;

    public MigrationInfo() {
        this(new DataSourceMigrationInfo());
    }

    public MigrationInfo(DataSourceMigrationInfo dsMigration) {
        this.dsMigration = dsMigration;
    }

    public DataSourceMigrationInfo getDsMigration() {
        return dsMigration;
    }

    public MigrationInfo withDsMigration(DataSourceMigrationInfo dsMigration) {
        return new MigrationInfo(dsMigration);
    }

    public MigrationInfo withDsMigrationRefType(DatabaseRef databaseRef, DataSourceType type) {
        return withDsMigration(dsMigration.withRefType(databaseRef, type));
    }

    public boolean dsTypeEquals(DatabaseRef databaseRef, DataSourceType type) {
        return dsMigration.getTypeO(databaseRef).isMatch(t -> type == t);
    }

    public boolean isNotEmpty() {
        return dsMigration.isNotEmpty();
    }
}
