package ru.yandex.chemodan.app.dataapi.core.dao.usermeta.migration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.ForcedUserShardInfoHolder;
import ru.yandex.chemodan.app.dataapi.core.dao.UserShardInfo;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.lang.Check;

/**
 * @author yashunsky
 */
public class MigrationSupport {
    public static void doWithShard(DataApiUserId uid, int shardId, Function0V action) {
        doWithShard(uid, shardId, action.asFunction0ReturnNull());
    }

    public static <T> T doWithShard(DataApiUserId uid, int shardId, Function0<T> action) {
        Option<UserShardInfo> prevShard = ForcedUserShardInfoHolder.getO();
        ForcedUserShardInfoHolder.set(new UserShardInfo(uid, false, shardId));

        try {
            return action.apply();
        } finally {
            ForcedUserShardInfoHolder.remove();
            prevShard.forEach(ForcedUserShardInfoHolder::set);
        }
    }

    public static void doWithShardPolicy(DataApiUserId uid, int shardId, MasterSlavePolicy policy, Function0V action) {
        MasterSlaveContextHolder.withPolicy(policy, () -> doWithShard(uid, shardId, action));
    }

    public static <T> T doWithShardPolicy(DataApiUserId uid, int shardId, MasterSlavePolicy policy, Function0<T> action) {
        return MasterSlaveContextHolder.withPolicy(policy, () -> doWithShard(uid, shardId, action));
    }

    public static <T> T getWithOptionalConsistencyCheck(
            DataApiUserId uid, int primaryShard, Option<Integer> secondaryShard, Function0<T> action)
    {
        T primaryResult = doWithShardPolicy(uid, primaryShard, MasterSlavePolicy.R_SM, action);
        if (secondaryShard.isNotEmpty()) {
            T secondaryResult = doWithShardPolicy(uid, secondaryShard.get(), MasterSlavePolicy.R_SM, action);
            Check.equals(primaryResult, secondaryResult, "shards mismatch");
        }

        return primaryResult;
    }
}
