package ru.yandex.chemodan.app.dataapi.core.dao.usermeta.migration;

import java.util.concurrent.Semaphore;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class RateLimiters {
    private final ChunkRateLimiter selectLimiter;
    private final ChunkRateLimiter insertLimiter;
    private final ChunkRateLimiter deleteLimiter;
    private final Semaphore sharpeiSemaphore;

    public ChunkRateLimiter forSelect() {
        return selectLimiter;
    }

    public ChunkRateLimiter forInsert() {
        return insertLimiter;
    }

    public ChunkRateLimiter forDelete() {
        return deleteLimiter;
    }

    public Semaphore forSharpei() {
        return sharpeiSemaphore;
    }
}
