package ru.yandex.chemodan.app.dataapi.core.datasources.disk;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceSession;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.db.ref.internalpublic.PublicDatabaseAlias;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPublicUserId;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppDatabaseSettings;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@RunWith(MockitoJUnitRunner.class)
public class DiskDataSourceUnitTest {
    private static final DataApiPassportUserId UID_NUMBER_ONE = new DataApiPassportUserId(1L);
    private static final PublicDatabaseAlias PUBLIC_DB_ALIAS = PublicDatabaseAlias.parseO(
            new DatabaseAppContext("197f6527da4b48a4bde884cd03fca56f"),
            ".pub._yadisk_config_db_v1"
    ).get();

    private static final UserDatabaseSpec USER_DATABASE_REF =
            UserDatabaseSpec.fromUserAndAlias(UID_NUMBER_ONE, PUBLIC_DB_ALIAS);

    @InjectMocks
    DiskDataSource dataApiManager;

    @Mock
    AppSettingsRegistry appSettingsRegistry;

    @Test
    public void uidOfPublicDatabaseSessionIsPublic() {
        Mockito.when(appSettingsRegistry.getDatabaseSettings(Mockito.any()))
                .thenReturn(AppDatabaseSettings.DEFAULT);

        DataSourceSession session = dataApiManager.openSession(USER_DATABASE_REF);
        Assert.equals(new DataApiPublicUserId(), session.uid());
    }
}
