package ru.yandex.chemodan.app.dataapi.core.datasources.disk;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.DeltasAppliedDatabase;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManagerImpl;

/**
 * @author dbrylev
 */
public class LockedDatabaseSession {
    private final Database db;
    private final DataApiManagerImpl.ManagerSession session;

    public LockedDatabaseSession(Database db, DataApiManagerImpl.ManagerSession session) {
        this.db = db;
        this.session = session;
    }

    public DeltasAppliedDatabase applyDeltas(RevisionCheckMode revCheckMode, ListF<Delta> deltas) {
        return session.applyDeltas(db, deltas, DataApiManagerImpl.RevisionChecker.cons(revCheckMode, db.rev));
    }

    public Database getDb() {
        return db;
    }

    // never use this method. It temporarily exists to update data, without creating a proper delta.
    @Deprecated
    public DataApiManagerImpl.ManagerSession getSessionForHacks() {
        return session;
    }
}
