package ru.yandex.chemodan.app.dataapi.core.datasources.migration;

import java.util.function.Consumer;

import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceSession;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceSessionDecorator;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.datasource.SpecificDataSource;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DsMigrationDataSource implements SpecificDataSource {
    private final SpecificDataSource dataSource;

    private final Consumer<UserDatabaseSpec> onCreateCallback;

    public DsMigrationDataSource(SpecificDataSource dataSource, Consumer<UserDatabaseSpec> onCreateCallback) {
        this.dataSource = dataSource;
        this.onCreateCallback = onCreateCallback;
    }

    @Override
    public DataSourceType type() {
        return dataSource.type();
    }

    @Override
    public DataSourceSession openSession(UserDatabaseSpec databaseSpec) {
        return new Session(dataSource.openSession(databaseSpec));
    }

    private class Session implements DataSourceSessionDecorator {
        final DataSourceSession session;

        boolean callbackCalled = false;

        Session(DataSourceSession session) {
            this.session = session;
        }

        @Override
        public Database getOrCreateDatabase() {
            Database database = session().getOrCreateDatabase();
            if (database.isNew) {
                callCallback();
            }
            return database;
        }

        @Override
        public Database createDatabase() {
            Database database = session().createDatabase();
            callCallback();
            return database;
        }

        @Override
        public DataSourceSession session() {
            return session;
        }

        private void callCallback() {
            if (callbackCalled) {
                return;
            }

            onCreateCallback.accept(databaseSpec());
            callbackCalled = true;
        }
    }
}
