package ru.yandex.chemodan.app.dataapi.core.datasources.migration;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceRegistry;
import ru.yandex.chemodan.app.dataapi.api.datasource.SpecificDataSource;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.BasicDataSourceRegistry;
import ru.yandex.chemodan.app.dataapi.core.datasources.DataSourceTypeRegistry;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@RequiredArgsConstructor
public class DsMigrationDataSourceRegistry implements DataSourceRegistry {

    private final DatabasesJdbcDao databasesDao;
    private final UserMetaManager userMetaManager;
    private final DataSourceTypeRegistry dsTypeRegistry;
    private final BasicDataSourceRegistry dsRegistry;
    private final DynamicProperty<Boolean> allowCreation = new DynamicProperty<>("allow-creation-of-migrating-db", true);

    @Override
    public SpecificDataSource getDataSource(UserDatabaseSpec db) {
        return dsTypeRegistry
                .getO(db.databaseRef())
                .filterMap(m -> m.migrationType().map(to -> {
                    if (userMetaManager.findMetaUser(db.uid()).map(user -> user.isMigrated(db.databaseRef())).getOrElse(false)) {
                        return dsRegistry.getDataSource(to);
                    } else {
                        if (allowCreation.get() || databasesDao.find(db.uid(), db.databaseRef()).isPresent()) {
                            return dsRegistry.getDataSource(m.currentType());
                        } else {
                            throw new IllegalStateException("no new dbs allowed in migrating data source");
                        }
                    }
                }))
                .getOrElse(() -> dsRegistry.getDataSource(db));
    }

}
