package ru.yandex.chemodan.app.dataapi.core.datasources.migration;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.BasicDataSourceRegistry;
import ru.yandex.chemodan.app.dataapi.core.datasources.DataSourceTypeRegistry;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DsMigrationManager {
    private static final Duration PAUSE_BEFORE_MIGRATION = Duration.standardMinutes(2);

    private static final Logger logger = LoggerFactory.getLogger(DsMigrationManager.class);

    private final UserMetaManager userMetaManager;

    private final DataSourceTypeRegistry dsTypeRegistry;

    private final BasicDataSourceRegistry dsRegistry;

    private final MapF<Tuple2<DataSourceType, DataSourceType>, DsMigration> migrations;

    public DsMigrationManager(UserMetaManager userMetaManager,
            DataSourceTypeRegistry dsTypeRegistry,
            BasicDataSourceRegistry dsRegistry,
            ListF<DsMigration> migrations)
    {
        this.userMetaManager = userMetaManager;
        this.dsRegistry = dsRegistry;
        this.dsTypeRegistry = dsTypeRegistry;
        this.migrations = migrations.toMap(m -> new Tuple2<>(m.type(), m));
    }

    public void migrate(DsMigrationSpec params) {
        migrate(params.dbRef(), params.srcType, params.tgtType);
    }

    public void migrate(DatabaseRef databaseRef, DataSourceType sourceType, DataSourceType targetType) {
        throw new UnsupportedOperationException("unsupported");

    }

    private void checkDsType(DataSourceType specifiedSrcType, DataSourceType actualSrcType) {
        if (specifiedSrcType != actualSrcType) {
            throw new IllegalArgumentException(
                    "Current data source type = " + actualSrcType + " passed type = " + specifiedSrcType
            );
        }
    }

    private DsMigration getMigration(DataSourceType sourceType, DataSourceType targetType) {
        return getMigration(new Tuple2<>(sourceType, targetType));
    }

    private DsMigration getMigration(Tuple2<DataSourceType, DataSourceType> type) {
        return migrations.getO(type)
                .getOrThrow("Unknown migration " + type);
    }
}
