package ru.yandex.chemodan.app.dataapi.core.datasources.migration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class DsMigrationSpec extends DefaultObject {
    public final Option<String> appO;
    public final String dbId;
    public final DataSourceType srcType;
    public final DataSourceType tgtType;

    public DsMigrationSpec(Option<String> appNameO, String dbId, DataSourceType srcType, DataSourceType tgtType) {
        this.appO = appNameO;
        this.dbId = dbId;
        this.srcType = srcType;
        this.tgtType = tgtType;
    }

    public static DsMigrationSpec cons(DatabaseRef dbRef, DataSourceType srcType, DataSourceType tgtType) {
        return new DsMigrationSpec(dbRef.appNameO(), dbRef.databaseId(), srcType, tgtType);
    }

    public DatabaseRef dbRef() {
        return DatabaseRef.cons(appO, dbId);
    }
}
