package ru.yandex.chemodan.app.dataapi.core.datasources.passport;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceProperties;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceTrait;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.datasource.SpecificDataSource;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.PassportDataSyncClient;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSource implements SpecificDataSource {
    public static final DataSourceProperties DS_PROPS = new DataSourceProperties(DataSourceTrait.NO_DB_REMOVAL);

    private final DiskDataSource diskDataSource;

    private final PassportDataSyncClient passportClient;

    private final UserMetaManager userMetaManager;

    private final RetryPolicy retryPolicy;

    public PassportDataSource(DiskDataSource diskDataSource, PassportDataSyncClient passportClient,
            UserMetaManager userMetaManager, RetryPolicy retryPolicy)
    {
        this.diskDataSource = diskDataSource;
        this.passportClient = passportClient;
        this.userMetaManager = userMetaManager;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public DataSourceType type() {
        return DataSourceType.PASSPORT;
    }

    @Override
    public PassportSession openSession(UserDatabaseSpec databaseSpec) {
        return new PassportSession(
                openDiskSession(databaseSpec), passportClient, userMetaManager, retryPolicy);
    }

    private DiskDataSource.Session openDiskSession(UserDatabaseSpec databaseSpec) {
        return diskDataSource.openSession(databaseSpec);
    }
}
