package ru.yandex.chemodan.app.dataapi.core.datasources.passport;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.datasources.migration.DiskToPassportMigration;
import ru.yandex.chemodan.app.dataapi.core.datasources.migration.PassportToDiskMigration;
import ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.PassportDataSyncClient;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Profile("dataapi")
@Configuration
public class PassportDataSourceContextConfiguration {
    @Bean
    public PassportDataSyncClient passportDataSyncClient(
            @Value("${blackbox.url}") String blackboxHost,
            @Value("${passport-api.url}") String passportApiHost,
            @Value("${passport-api.consumer}") String consumer,
            @Value("${passport-api.maxConnectionCount}") int maxConnectionCount)
    {
        return  PassportDataSyncClient.builder()
                .readUrl(blackboxHost)
                .saveUrl(passportApiHost, consumer)
                .maxConnectionCount(maxConnectionCount)
                .build();
    }

    @Bean
    public PassportDataSource passportDataSource(DiskDataSource diskDataSource,
            PassportDataSyncClient passportClient,
            UserMetaManager userMetaManager,
            @Value("${dataapi.passport.slave-delay.max-retries}") int maxRetries,
            @Value("${dataapi.passport.slave-delay.retry-delay}") Duration retryDelay)
    {
        return new PassportDataSource(
                diskDataSource, passportClient, userMetaManager,
                new RetryPolicy()
                        .withMaxRetries(maxRetries)
                        .withDelay(retryDelay.getMillis(), TimeUnit.MILLISECONDS)
        );
    }

    @Bean
    public DiskToPassportMigration diskToPassportMigration(DiskDataSource diskDs, PassportDataSource passportDs) {
        return new DiskToPassportMigration(diskDs, passportDs);
    }

    @Bean
    public PassportToDiskMigration passportToDiskMigration(UserMetaManager userMetaManager, DiskDataSource diskDs, PassportDataSource passportDs) {
        return new PassportToDiskMigration(userMetaManager, diskDs, passportDs);
    }

}
