package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client;

import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.bender.EscapedJsonWrapperMarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
class PassportDataSyncChangeSerializer {
    private static final BenderMapper basicMapper = DataApiBenderUtils.mapper();
    private static final BenderMapper mapper = new BenderMapper(new BenderConfiguration(
            new BenderSettings(),
            DataApiBenderUtils.marshallerUnmarshallerFactoryBuilder()
                    .add(PassportDataSyncRecordValue.class,
                            EscapedJsonWrapperMarshaller.fromSerializer(PassportDataSyncRecordValue.serializer))
                    .add(Delta.class, new EscapedJsonWrapperMarshaller(basicMapper::serializeJson))
                    .build()
    ));

    public static byte[] serializeJson(PassportDataSyncChange change) {
        return mapper.serializeJson(change);
    }

    public static String serializeJsonStr(PassportDataSyncChange change) {
        return new String(serializeJson(change), CharsetUtils.UTF8_CHARSET);
    }

}
