package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.VersionedDataApiRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncData extends DefaultObject {
    public final PassportUid uid;

    public final Tuple2List<VersionedDataApiRecord, Long> recordsToDbRevs;

    public final Tuple2List<String, Delta> deltas;

    public final Option<Long> revisionO;

    public PassportDataSyncData(PassportUid uid, Tuple2List<VersionedDataApiRecord, Long> recordsToDbRevs,
            Tuple2List<String, Delta> deltas, Option<Long> revisionO)
    {
        this.uid = uid;
        this.recordsToDbRevs = recordsToDbRevs;
        this.deltas = deltas;
        this.revisionO = revisionO;
    }

    public static PassportDataSyncData consRecords(
            PassportUid uid, Tuple2List<VersionedDataApiRecord, Long> recordsToDbRevs)
    {
        return new PassportDataSyncData(uid, recordsToDbRevs, Tuple2List.tuple2List(), Option.empty());
    }

    public static PassportDataSyncData consDeltas(PassportUid uid, Tuple2List<String, Delta> deltas) {
        return new PassportDataSyncData(uid, Tuple2List.tuple2List(), deltas, Option.empty());
    }

    public static PassportDataSyncData consRevision(PassportUid uid, Long revision) {
        return new PassportDataSyncData(uid, Tuple2List.tuple2List(), Tuple2List.tuple2List(), Option.of(revision));
    }

    public PassportDataSyncData withDeltasSortedAs(ListF<String> deltaIds) {
        return new PassportDataSyncData(uid, recordsToDbRevs,
                deltas.sortedBy1(new Comparator<String>() {
                    final MapF<String, Integer> idToPosition = deltaIds.zipWithIndex().toMap();

                    @Override
                    public int compare(String id1, String id2) {
                        return getPosition(id1).compareTo(getPosition(id2));
                    }

                    Integer getPosition(String id) {
                        return idToPosition.getO(id)
                                .getOrElse(Integer.MAX_VALUE);
                    }
                }),
                revisionO
        );
    }

    public Delta getDelta() {
        return getDeltas()
                .single();
    }

    public ListF<Delta> getDeltas() {
        return deltas.get2();
    }

    public ListF<DataRecord> getDataRecords(Database database) {
        return getDataRecords(database.uid, database.dbHandle);
    }

    public ListF<VersionedDataApiRecord> getRecords() {
        return recordsToDbRevs.get1();
    }

    public Option<Long> getMaxDbRev() {
        return recordsToDbRevs.get2().maxO();
    }

    private ListF<DataRecord> getDataRecords(DataApiUserId uid, DatabaseHandle dbHandle) {
        return recordsToDbRevs.map((record, rev) -> record.toDataRecord(uid, dbHandle));
    }
}
