package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldsMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.api.data.record.VersionedDataApiRecord;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class PassportDataSyncRecordValue extends DefaultObject {
    private static final BenderParserSerializer<PassportDataSyncRecordValue> parserSerializer =
            Bender.cons(
                    PassportDataSyncRecordValue.class,
                    new BenderConfiguration(
                            new BenderSettings(),
                            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                                    .add(DataFields.class,
                                            new DataFieldsMarshallerUnmarshaller(),
                                            new DataFieldsMarshallerUnmarshaller())
                                    .build()
                    )
            );

    public static final BenderParser<PassportDataSyncRecordValue> parser = parserSerializer.getParser();

    public static final BenderSerializer<PassportDataSyncRecordValue> serializer = parserSerializer.getSerializer();

    @BenderPart(name = "rev", strictName = true)
    public final long rev;

    @BenderPart(name = "data", strictName = true)
    public final DataFields data;

    public PassportDataSyncRecordValue(long rev, DataFields data) {
        this.rev = rev;
        this.data = data;
    }

    public static PassportDataSyncRecordValue fromVersionedRecord(VersionedDataApiRecord record) {
        return new PassportDataSyncRecordValue(record.rev(), record.data());
    }
}
