package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.errors.PassportUserNotFoundException;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class PassportUsersDataSyncData extends DefaultObject {
    private final MapF<PassportUid, PassportDataSyncData> datas;

    public PassportUsersDataSyncData(MapF<PassportUid, PassportDataSyncData> datas) {
        this.datas = datas;
    }

    public PassportDataSyncData getOrThrow(PassportUid uid) {
        return datas.getO(uid).getOrThrow(() -> new PassportUserNotFoundException(uid));
    }
}
