package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.bender;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.bender.serialize.EmptyMarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EscapedJsonWrapperMarshaller extends StringValueMarshaller {
    private static final Charset DEFAULT_CHARSET = CharsetUtils.UTF8_CHARSET;

    private final Function<Object, byte[]> serializerF;

    private final Charset charset;

    public EscapedJsonWrapperMarshaller(Function<Object, byte[]> serializerF) {
        this(serializerF, DEFAULT_CHARSET);
    }

    public EscapedJsonWrapperMarshaller(Function<Object, byte[]> serializerF, Charset charset) {
        this.serializerF = serializerF;
        this.charset = charset;
    }

    @SuppressWarnings("unchecked")
    public static <T> EscapedJsonWrapperMarshaller fromSerializer(BenderSerializer<T> serializer) {
        return new EscapedJsonWrapperMarshaller(o -> serializer.serializeJson((T) o));
    }

    @SuppressWarnings("unused")
    public static EscapedJsonWrapperMarshaller fromMarshaller(ToFieldMarshaller marshaller) {
        return new EscapedJsonWrapperMarshaller(obj -> serialize(obj, marshaller), DEFAULT_CHARSET);
    }

    private static byte[] serialize(Object obj, ToFieldMarshaller marshaller) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BenderJsonWriter writer = BenderJsonWriter.json(os);
        marshaller.writeJsonToField(writer, obj, new EmptyMarshallerContext());
        writer.flush();
        return os.toByteArray();
    }

    @Override
    protected String toStringValue(Object obj) {
        return new String(serialize(obj), charset);
    }

    private byte[] serialize(Object obj) {
        return serializerF.apply(obj);
    }
}
