package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.bender;

import java.util.function.BiFunction;

import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.BenderParserUtils;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EscapedJsonWrapperUnmarshaller implements JsonFieldLevelUnmarshaller {
    private final BiFunction<String, UnmarshallerContext, Object> parser;

    private EscapedJsonWrapperUnmarshaller(BiFunction<String, UnmarshallerContext, Object> parser) {
        this.parser = parser;
    }

    @SuppressWarnings("unused")
    public static EscapedJsonWrapperUnmarshaller fromUnmarshaller(JsonFieldLevelUnmarshaller unmarshaller) {
        return fromBenderParseJson(unmarshaller::parseJsonNode);
    }

    public static EscapedJsonWrapperUnmarshaller fromParser(BenderParser<?> parser) {
        return fromBenderParseJson(parser::parseJsonO);
    }

    private static EscapedJsonWrapperUnmarshaller
    fromBenderParseJson(BiFunction<BenderJsonNode, UnmarshallerContext, ParseResult<?>> parseJsonF)
    {
        return new EscapedJsonWrapperUnmarshaller(
                (value, context) ->
                        parseJsonF.apply(BenderParserUtils.json(value), context)
                                .getOrThrow()
        );
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        return ParseResult.result(
                parser.apply(node.getValueAsString(), context)
        );
    }
}
