package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.errors;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncApiException extends RuntimeException {
    public final String status;
    public final ListF<String> errors;

    public PassportDataSyncApiException(String status, ListF<String> errors) {
        super("Received error from Passport API " + ". " + StringUtils.join(errors, ", "));
        this.status = status;
        this.errors = errors;
    }
}
