package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.errors;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class PassportDataSyncBlackboxException extends RuntimeException {
    private static final Pattern2 revMismatchPattern =
            Pattern2.compile("BlackBox error: Revision mismatch .+rev='([0-9]+)'");

    @BenderPart(name = "error")
    public final String error;

    @BenderPart(name = "exception")
    public final BlackboxException exception;

    public PassportDataSyncBlackboxException(String error, int exceptionId, String exceptionValue) {
        this(error, new BlackboxException(exceptionId, exceptionValue));
    }

    public PassportDataSyncBlackboxException(String error, BlackboxException exception) {
        this.error = error;
        this.exception = exception;
    }

    public RuntimeException getCauseOrSelf() {
        Option<Long> blackboxRev = revMismatchPattern.findFirstGroup(error).map(Long::parseLong);
        return blackboxRev.isPresent()
                ? new PassportDataSyncRevisionMismatchException(Option.empty(), blackboxRev)
                : this;
    }

    @Bendable
    public static class BlackboxException extends DefaultObject {
        @BenderPart(name = "id")
        final int id;

        @BenderPart(name = "value")
        final String value;

        BlackboxException(int id, String value) {
            this.id = id;
            this.value = value;
        }
    }
}
