package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.errors;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncBlackboxExceptionTest {
    @Test
    public void causeOrSelfOnRevisionMismatch() {
        Assert.equals(
                new PassportDataSyncRevisionMismatchException(Option.empty(), Option.of(15L)),
                new PassportDataSyncBlackboxException(
                        "BlackBox error: Revision mismatch for" +
                                "app_id='test',db_id='test1',coll_id='test',rev='15',rec_id='test0'",
                        2,
                        "INVALID_PARAMS"
                ).getCauseOrSelf()
        );
    }

    @Test
    public void causeOrSelfOnOtherError() {
        PassportDataSyncBlackboxException ex =
                new PassportDataSyncBlackboxException("BlackBox error: Some error", 2, "INVALID_PARAMS");
        Assert.equals(ex, ex.getCauseOrSelf());
    }
}
