package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.errors;

import java.util.Objects;

import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncRevisionMismatchException extends RuntimeException {
    public final Option<Long> requestRev;

    public final Option<Long> passportRev;

    public PassportDataSyncRevisionMismatchException(Option<Long> requestRev, Option<Long> passportRev) {
        super("Revision mismatch"
                + requestRev.map(r -> " request revision = " + r).mkString("")
                + passportRev.map(r -> " passport revision = " + r).mkString("")
        );
        this.requestRev = requestRev;
        this.passportRev = passportRev;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PassportDataSyncRevisionMismatchException)) {
            return false;
        }

        PassportDataSyncRevisionMismatchException other = (PassportDataSyncRevisionMismatchException) obj;
        return requestRev.equals(other.requestRev)
                && passportRev.equals(other.passportRev);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestRev, passportRev);
    }
}
