package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.errors;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author dbrylev
 */
public class PassportUserNotFoundException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSource {

    public PassportUserNotFoundException(PassportUid uid) {
        super(ErrorNames.PASSPORT_USER_NOT_FOUND, "User not found in passport: " + uid);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }

}
