package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.request;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncGetDeltas extends DefaultObject implements PassportDataSyncRequestParam {
    private final ListF<String> deltaIds;

    public PassportDataSyncGetDeltas(String... deltaIds) {
        this(Cf.list(deltaIds));
    }

    public PassportDataSyncGetDeltas(ListF<String> deltaIds) {
        this.deltaIds = deltaIds;
    }

    @Override
    public PassportDataSyncRequestType type() {
        return PassportDataSyncRequestType.DELTAS;
    }

    @Override
    public String value() {
        return StringUtils.join(deltaIds, ",");
    }

    public ListF<String> getIds() {
        return deltaIds;
    }
}
