package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.request;

import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncGetRevision extends DefaultObject implements PassportDataSyncRequestParam {
    private static final BenderSerializer<Param> serializer = Bender.serializer(Param.class);

    private final DatabaseRef dbRef;

    public PassportDataSyncGetRevision(DatabaseRef dbRef) {
        this.dbRef = dbRef;
    }

    @Override
    public PassportDataSyncRequestType type() {
        return PassportDataSyncRequestType.REVISION;
    }

    @Override
    public String value() {
        return new String(
                serializer.serializeJson(new Param(dbRef)),
                CharsetUtils.UTF8_CHARSET
        );
    }

    @Bendable
    private static class Param extends DefaultObject {
        @BenderPart(name = "app_id", strictName = true)
        final String app;

        @BenderPart(name = "db_id", strictName = true)
        final String databaseId;

        Param(DatabaseRef dbRef) {
            this.app = dbRef.dbAppId();
            this.databaseId = dbRef.databaseId();
        }
    }
}
