package ru.yandex.chemodan.app.dataapi.core.datasources.passport.client.request;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportDataSyncRequest extends DefaultObject {
    public final DataApiPassportUserId userId;

    private final MapF<PassportDataSyncRequestType, PassportDataSyncRequestParam> params;

    public PassportDataSyncRequest(DataApiPassportUserId userId, PassportDataSyncRequestParam... params) {
        this(userId,
                Cf.list(params)
                        .toMapMappingToKey(PassportDataSyncRequestParam::type)
        );
    }

    private PassportDataSyncRequest(
            DataApiPassportUserId userId,
            MapF<PassportDataSyncRequestType, PassportDataSyncRequestParam> params)
    {
        this.userId = userId;
        this.params = params;
    }

    public PassportDataSyncRequest with(PassportDataSyncRequestParam request) {
        return new PassportDataSyncRequest(userId, params.plus1(request.type(), request));
    }

    public PassportUid getPassportUid() {
        return userId.uid;
    }

    public CollectionF<PassportDataSyncRequestParam> getParams() {
        return params.values();
    }

    public ListF<String> getDeltaIds() {
        return params.getO(PassportDataSyncRequestType.DELTAS)
                .map(param -> (PassportDataSyncGetDeltas) param)
                .map(PassportDataSyncGetDeltas::getIds)
                .getOrElse(Cf.list());
    }
}
