package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney;

import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum YaMoneyCollectionRef {
    DATA(YaMoneyDatabaseRef.DATA, "userdata"),
    SETTINGS(YaMoneyDatabaseRef.SETTINGS, "usersettings")
    ;

    final YaMoneyDatabaseRef databaseRef;
    final CollectionRef collectionRef;

    YaMoneyCollectionRef(YaMoneyDatabaseRef databaseRef, String collectionId) {
        this.databaseRef = databaseRef;
        this.collectionRef = databaseRef.dbRef()
                .consColRef(collectionId);
    }

    public YaMoneyDatabaseRef databaseRef() {
        return databaseRef;
    }

    public CollectionRef collectionRef() {
        return collectionRef;
    }
}
