package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum YaMoneyDatabaseRef implements DatabaseRefSource {
    DATA("userdata"),
    SETTINGS("usersettings");

    private static final MapF<AppDatabaseRef, YaMoneyDatabaseRef> refToEnum =
            Cf.x(values())
                    .toMapMappingToKey(YaMoneyDatabaseRef::dbRef);

    private final AppDatabaseRef databaseRef;

    YaMoneyDatabaseRef(String databaseId) {
        this.databaseRef = YaMoneyAppContextHolder.APP_CONTEXT.consDbRef(databaseId);
    }

    public static YaMoneyDatabaseRef byDatabaseRef(DatabaseRef databaseRef) {
        return byDatabaseRefO(databaseRef)
                .getOrThrow(() -> new IllegalArgumentException("Unknown Ya.Money database = " + databaseRef));
    }

    public static Option<YaMoneyDatabaseRef> byDatabaseRefO(DatabaseRef databaseRef) {
        if (!(databaseRef instanceof AppDatabaseRef)) {
            return Option.empty();
        }
        return refToEnum.getO((AppDatabaseRef) databaseRef);
    }

    @Override
    public AppDatabaseRef dbRef() {
        return databaseRef;
    }

    public DatabaseHandle generateHandle(DataApiUserId uid) {
        return new DatabaseHandle(databaseRef, generateHandleValue(uid));
    }

    public String generateHandleValue(DataApiUserId uid) {
        return String.format("%s.%s.%s", databaseRef.appName(), uid, databaseRef.databaseId());
    }
}
