package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleDataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.records.AbstractYaMoneyEntity;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.records.FinesSubscriptionSettings;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.records.UserDataRecord;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum YaMoneyRecordFixtures {
    DATA(YaMoneyDatabaseRef.DATA,
            UserDataRecord.drivingLicense("0", "76ХХ123456")
                    .withTitle("My driving license")
                    .withSubscription(),
            UserDataRecord.registrationCertificate("1", "1234567890")
                    .withSubscription(),
            UserDataRecord.registrationNumber("2", "77ХХ123456")
                    .withTitle("Wife's vehicle registration number")
    ),
    SETTINGS(YaMoneyDatabaseRef.SETTINGS,
            new FinesSubscriptionSettings()
                    .withEmail()
                    .withSms()
                    .withNavigatorPush()
    ),
    ;

    final YaMoneyDatabaseRef databaseRef;
    final ListF<AbstractYaMoneyEntity> entities;

    YaMoneyRecordFixtures(YaMoneyDatabaseRef databaseRef,
            AbstractYaMoneyEntity firstEntity, AbstractYaMoneyEntity... entities) {
        this.databaseRef = databaseRef;
        this.entities = Cf.list(firstEntity).plus(entities);
    }

    public MapF<YaMoneyDatabaseRef, ListF<AbstractYaMoneyEntity>> dbRefToEntities() {
        return entities.groupBy(e -> e.collectionRef().databaseRef());
    }

    public ListF<SimpleDataRecord> getSimpleDataRecords() {
        return entities.map(AbstractYaMoneyEntity::toSimpleRecord);
    }

    public Database consDatabase(DataApiPassportUserId uid) {
        DatabaseHandle DATABASE_HANDLE = databaseRef.generateHandle(uid);
        return new Database(uid, DATABASE_HANDLE, 0,
                new DatabaseMeta(Instant.now(), Instant.now(), DataSize.ZERO, 0));
    }

    @Override
    public String toString() {
        return databaseRef.dbRef()
                .toString();
    }
}
