package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney;

import java.net.URI;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.core.xiva.DataApiXivaPushSender;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Profile("dataapi")
@Configuration
public class YamoneyContextConfiguration {
    @Bean
    public YamoneyDatabaseDataSource yamoneyDataSource(
            @Value("${dataapi.yamoney.datasync-adapter.url}") URI baseUrl,
            DataApiXivaPushSender xivaPushSender)
    {
        return new YamoneyDatabaseDataSource(
                new YaMoneyDataApiClient(baseUrl, yamoneyHttpClientConfigurator().configure()),
                xivaPushSender
        );
    }

    @Bean
    @OverridableValuePrefix("yamoney")
    public HttpClientConfigurator yamoneyHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
