package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.datasource.AuxiliaryDataSource;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceProperties;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceTrait;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.core.xiva.DataApiXivaPushSender;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class YamoneyDatabaseDataSource implements AuxiliaryDataSource {
    public static final DataSourceProperties DS_PROPS =
            new DataSourceProperties(
                    DataSourceTrait.NEVER_KEEP_DELTAS,
                    DataSourceTrait.NO_DB_DESCRIPTION,
                    DataSourceTrait.NO_DB_REMOVAL,
                    DataSourceTrait.NO_DB_SIZE,
                    DataSourceTrait.EXTERNAL_CHANGE_ALLOWED
            );

    private final YaMoneyDataApiClient client;

    private final DataApiXivaPushSender xivaPushSender;

    public YamoneyDatabaseDataSource(YaMoneyDataApiClient client, DataApiXivaPushSender xivaPushSender) {
        this.client = client;
        this.xivaPushSender = xivaPushSender;
    }

    @Override
    public DataSourceType type() {
        return DataSourceType.YA_MONEY;
    }

    @Override
    public ListF<DatabaseRef> getDatabaseRefs() {
        return Cf.x(YaMoneyDatabaseRef.values())
                .map(YaMoneyDatabaseRef::dbRef);
    }

    @Override
    public YamoneyDatabaseSession openSession(UserDatabaseSpec databaseSpec) {
        return new YamoneyDatabaseSession(databaseSpec, client, xivaPushSender);
    }
}
