package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.records;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleDataRecord;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.YaMoneyCollectionRef;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractYaMoneyEntity extends DefaultObject {
    abstract public YaMoneyCollectionRef collectionRef();

    abstract protected String recordId();

    abstract protected DataFields data();

    public SimpleDataRecord toSimpleRecord() {
        return new SimpleDataRecord(recordRef(), data());
    }

    public RecordRef recordRef() {
        return collectionRef().collectionRef()
                .consRecordRef(recordId());
    }
}
