package ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.records;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataField;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.YaMoneyCollectionRef;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FinesSubscriptionSettings extends AbstractYaMoneyEntity {
    final boolean email;
    final boolean sms;
    final boolean navigatorPush;

    private FinesSubscriptionSettings(boolean email, boolean sms, boolean navigatorPush) {
        this.email = email;
        this.sms = sms;
        this.navigatorPush = navigatorPush;
    }

    public FinesSubscriptionSettings() {
        this(false, false, false);
    }

    public FinesSubscriptionSettings withEmail() {
        return new FinesSubscriptionSettings(true, sms, navigatorPush);
    }

    public FinesSubscriptionSettings withSms() {
        return new FinesSubscriptionSettings(email, true, navigatorPush);
    }

    public FinesSubscriptionSettings withNavigatorPush() {
        return new FinesSubscriptionSettings(email, sms, true);
    }

    @Override
    public YaMoneyCollectionRef collectionRef() {
        return YaMoneyCollectionRef.SETTINGS;
    }

    @Override
    protected String recordId() {
        return "fines_subscription_settings";
    }

    @Override
    protected DataFields data() {
        return new DataFields(
                NamedDataField.bool("subscription_email", email),
                NamedDataField.bool("subscription_sms", sms),
                NamedDataField.bool("subscription_push_nav", navigatorPush)
        );
    }
}
