package ru.yandex.chemodan.app.dataapi.core.datasources.ydb.dao;

import javax.annotation.Nullable;

import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.values.Type;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.ydb.dao.YdbRowMapper;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author tolmalev
 */
public class DatabaseMapper implements YdbRowMapper<Database> {

    public static final DatabaseMapper FROM_REAL = new DatabaseMapper("modification_time");
    public static final DatabaseMapper FROM_DELETED = new DatabaseMapper("delete_time");

    private final String modificationTimeColumn;

    private DatabaseMapper(String modificationTimeColumn) {
        this.modificationTimeColumn = modificationTimeColumn;
    }

    @Override
    public Database mapRow(ResultSetReader rs, int rowNum) {
        return new Database(
                DataApiUserId.parse(getString(rs, "user_id")),
                DatabaseHandle.fromAppDbId(
                        Option.ofNullable(getString(rs, "app")),
                        getString(rs, "dbId"),
                        getString(rs, "handle")),
                rs.getColumn("rev").getInt64(),
                new DatabaseMeta(
                        new Instant(rs.getColumn("creation_time").getTimestamp().toEpochMilli()),
                        new Instant(rs.getColumn(modificationTimeColumn).getTimestamp().toEpochMilli()),
                        new DataSize(rs.getColumn("size").getInt64()),
                        rs.getColumn("records_count").getInt64(),
                        Option.ofNullable(getString(rs, "description"))
                )
        );
    }

    @Nullable
    static String getString(ResultSetReader rs, String columnName) {
        ValueReader c = rs.getColumn(columnName);
        if (c.getType().getKind() == Type.Kind.OPTIONAL) {
            if (!c.isOptionalItemPresent()) {
                return null;
            }
        }

        if (!c.isOptionalItemPresent()) {
            return null;
        }

        return new String(c.getString());
    }

}
