package ru.yandex.chemodan.app.dataapi.core.dump;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.web.DataapiRequestAppHolder;
import ru.yandex.chemodan.app.dataapi.worker.dump.DumpDatabaseUsersProcessor;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.chemodan.log.TskvLogger;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class DatabaseChangesTskvLogger {
    public static final Logger logger = LoggerFactory.getLogger(DumpDatabaseUsersProcessor.class);

    public static final TskvLogger tskvLogger = new TskvLogger("dataapi-database-changes");
    private static final String def = "";

    public static void log(MethodType type, Database database, DataRecord record) {
        try {
            RecordChangeEvent event = RecordChangeEvent.cons(type, database, record, Option.empty(),
                    getYcrid(), getDataapiRequestApp());

            tskvLogger.log(event.getValues());

        } catch (RuntimeException e) {
            logger.error("Writing record update to special tskv log failed for "
                    + database.uid + "." + database.dbRef().toString() + " "
                    + new String(RecordChangeEvent.mapper.serializeJson(record.toSnapshotPojoRow())));
        }
    }

    public static String getYcrid() {
        return safeGet(YandexCloudRequestIdHolder.getO());
    }

    public static String getDataapiRequestApp() {
        return safeGet(DataapiRequestAppHolder.getO());
    }

    private static String safeGet(Option<String> value) {
        return value.getOrElse(def);
    }
}
