package ru.yandex.chemodan.app.dataapi.core.dump;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;

/**
 * @author metal
 */
public class DatabaseChangesTskvLoggerEventHandler implements DatabaseChangedEventAsyncHandler {
    private final AppSettingsRegistry appSettingsRegistry;

    public DatabaseChangesTskvLoggerEventHandler(AppSettingsRegistry appSettingsRegistry) {
        this.appSettingsRegistry = appSettingsRegistry;
    }

    @Override
    public void databaseChanged(DatabaseChange databaseChange) {
        if (needToDumpInYt(databaseChange.sourceDatabase())) {
            log(databaseChange.sourceDatabase(), MethodType.INSERT, databaseChange.getNewRecords());
            log(databaseChange.sourceDatabase(), MethodType.UPDATE, databaseChange.getUpdatedRecords());
            log(databaseChange.sourceDatabase(), MethodType.DELETE, databaseChange.getDeletedRecordsWithLastRev());
        }
    }

    private void log(Database database, MethodType type, ListF<DataRecord> records) {
        records.forEach(record -> DatabaseChangesTskvLogger.log(type, database, record));
    }

    private boolean needToDumpInYt(Database database) {
        return appSettingsRegistry.getDatabaseSettings(database).isHaveDumpInYt();
    }
}
