package ru.yandex.chemodan.app.dataapi.core.dump;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettings;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class RecordChangeEventSerializeTest {

    private static final Database database = Database.consNew(
            new DataApiPassportUserId(1L), DatabaseHandle.consGlobal("dbId", "handle"));

    private static final DataRecordId recordId = new DataRecordId(database.dbHandle, "colId", "recId");

    @Test
    public void primal() {
        DataRecord record = new DataRecord(database.uid, recordId, 0, Cf.map(
                "string", DataField.string("value"),
                "number", DataField.integer(27)));

        RecordChangeEvent event = RecordChangeEvent.cons(MethodType.UPDATE, database, record, Option.empty(), "", "");

        Assert.equals("["
                + "{\"field_id\":\"string\",\"value\":{\"type\":\"string\",\"string\":\"value\"}},"
                + "{\"field_id\":\"number\",\"value\":{\"type\":\"integer\",\"integer\":27}}]", event.recordData);
    }

    @Test
    public void generic() {
        DataRecord record = new DataRecord(database.uid, recordId, 0,
                Cf.map("number", DataField.integer(27)));

        TypeSettings type = new TypeSettings(""
                + "{"
                + "  \"type\":\"object\","
                + "  \"properties\": {"
                + "    \"string\": {\"type\": \"string\"},"
                + "    \"number\": {\"type\": \"integer\"}"
                + "  }"
                + "}",
                "type", "string", false, false, Cf.list(), Mockito.mock(TypeLocation.class), Option.empty(), false);

        RecordChangeEvent event = RecordChangeEvent.cons(MethodType.INSERT, database, record, Option.of(type), "", "");

        Assert.equals("{\"number\":27,\"string\":\"recId\"}", event.recordData);
    }
}
