package ru.yandex.chemodan.app.dataapi.core.generic;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class DeletionSettings extends DefaultObject {
    private final String datePaths;
    private final long deletionIntervalMs;

    public DeletionSettings(String datePaths, Duration deletionInterval) {
        this.datePaths = datePaths;
        this.deletionIntervalMs = deletionInterval.getMillis();
    }

    public ListF<String> getDatePaths() {
        return Cf.list(datePaths.split(";"));
    }

    public Duration getDeletionInterval() {
        return new Duration(deletionIntervalMs);
    }
}
