package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.FormatConverter;

/**
 * @author Denis Bakharev
 */
public class FormatConverterCache {
    private final MapF<String, FormatConverter> typeNameToConverterMap = Cf.concurrentHashMap();

    public FormatConverter getConverter(TypeSettings typeSettings) {
        Option<FormatConverter> cachedConverterO = typeNameToConverterMap.getO(typeSettings.typeName);
        if (!cachedConverterO.isPresent() || !typeSettings.jsonSchema.equals(cachedConverterO.get().jsonSchema)) {
            FormatConverter newConverter = new FormatConverter(typeSettings.jsonSchema);
            typeNameToConverterMap.put(typeSettings.typeName, newConverter);
            return newConverter;
        }

        return cachedConverterO.get();
    }
}
